<?php
/**
 * Ipay88 Inc
 * @author Ipay88 Inc <pvchi@ipay88.com>
 * @package Ipay88\ThirdpartyIntegration\Magento
 * @Description: Using for Indonesia Only
 */
require_once Mage::getBaseDir('lib') . '/ipay88-php/Include.php';

class Ipay88_Ipay88_Block_Checkout_Form_Method_Abstract extends Mage_Payment_Block_Form
{
    private $modelName;
    private $paymentModel;

    /**
     * Get total amount of current order
     * @return mixed|null
     */
    public function getTotal()
    {
        return $this->getOrder() ? $this->getOrder()->getGrandTotal() : null;
    }

    /**
     * Get currency code of current order
     * @return string|null
     */
    public function getOrderCurrencyCode()
    {
        return $this->getOrder() ? $this->getOrder()->getOrderCurrencyCode() : null;
    }

    /**
     * Set payment model name
     * @param $name
     */
    public function setPaymentModelName($name)
    {
        $this->modelName = $name;
    }

    /**
     * Get Payment Model
     * @return false|Mage_Core_Model_Abstract
     */
    public function getPaymentModel()
    {
        if (!$this->paymentModel) {
            $this->paymentModel = Mage::getModel('ipay88/method_' . $this->modelName);
        }

        return $this->paymentModel;
    }
}