<?php

/**
 * Ipay88 Inc
 * @author Ipay88 Inc <pvchi@ipay88.com>
 * @package Ipay88\ThirdpartyIntegration\Magento
 * @Description: Using for Indonesia Only
 */

class Ipay88_Ipay88_Block_Checkout_Form_Method_Hosted extends Ipay88_Ipay88_Block_Checkout_Form_Method_Abstract
{
    /**
     * Set template for block
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setPaymentModelName('hosted');
        $this->setTemplate('ipay88/checkout/form/method/hosted.phtml');
    }

    /**
     * Get merchant public key from configuration
     * @return string|null
     */
    public function getMerchantCode()
    {
        if ($this->getPaymentModel()) {
            return $this->getPaymentModel()->getConfigData('ipay88_merchant_code');
        }
        return null;
    }

    /**
     * Get private key from configuration
     * @return string|null
     */
    public function getMerchantKey()
    {
        if ($this->getMethod()) {
            return $this->getPaymentModel()->getConfigData('ipay88_merchent_key');
        }
        return null;
    }


    /**
     * Retrieve payment configuration object
     *
     * @return Mage_Payment_Model_Config
     */
    protected function _getConfig()
    {
        return Mage::getSingleton('payment/config');
    }

    /**
     * Get last order
     */
    protected function getOrder()
    {
        if (!$this->_order) {
            $session = Mage::getSingleton('checkout/session');
            $this->_order = $this->loadOrderById($session->getLastRealOrderId());
        }
        return $this->_order;
    }

    protected function loadOrderById($orderId)
    {
        return Mage::getModel('sales/order')->loadByIncrementId($orderId);
    }
}