<?php
/**
 * Ipay88 Inc
 * @author Ipay88 Inc <pvchi@ipay88.com>
 * @package Ipay88\ThirdpartyIntegration\Magento
 * @Description: Using for Indonesia Only
 */
require_once Mage::getBaseDir('lib') . '/ipay88-php/Include.php';

class Ipay88_Ipay88_Helper_Hosted extends Mage_Core_Helper_Abstract
{
    /**
     * @return string
     */
    function getPaymentGatewayUrl()
    {
        $configValue = Mage::getStoreConfig('payment/ipay88_hosted/ipay88_istest');

        if($configValue) {
            return Ipay88_Indonesia::URL_PAYMENT_SANDBOX;
        } else {
            return Ipay88_Indonesia::URL_PAYMENT_PRODUCTION;
        }
    }

    /**
     * @return boolean
     */
    public function isTest() {
        return Mage::getStoreConfig('payment/ipay88_hosted/ipay88_istest');
    }

    public function prepareHostedBankConfig() {
        // Payment methods, please view technical spec for latest update.
        return array(
            Ipay88_Indonesia::PAYMENT_METHOD_CREDIT_CONFIG_KEY              => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_credit_card_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_MANDIRI_CLICKPAY_CONFIG_KEY    => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_mandiri_clickpay_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_XL_TUNAI_CONFIG_KEY            => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_xl_tuinai_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_VIRTUAL_ACCOUNT_CONFIG_KEY     => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_virtual_account_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_KARTUKU_CONFIG_KEY             => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_karkutu_bank_config'),

            Ipay88_Indonesia::PAYMENT_METHOD_CIMB_CLICKS_CONFIG_KEY         => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_cimb_click_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_MANDIRI_ECASH_CONFIG_KEY       => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_mandiri_ecash_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_IB_MUAMALAT_CONFIG_KEY         => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_ib_muamalat_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_TCASH_CONFIG_KEY               => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_tcash_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_INDOSAT_DOMPETKU_CONFIG_KEY    => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_indosat_dompetku_bank_config'),

            Ipay88_Indonesia::PAYMENT_METHOD_ATM_AUTOMATIC_CONFIG_KEY       => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_atm_automatic_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_FLASHIZ_CONFIG_KEY             => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_flashiz_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_PAY4ME_CONFIG_KEY              => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_pay4me_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_DANAMON_ONLONE_CONFIG_KEY      => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_danamon_online_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_PERMATA_ATM_CONFIG_KEY         => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_permata_atm_bank_config'),
            Ipay88_Indonesia::PAYMENT_METHOD_PAYPAL_CONFIG_KEY              => Mage::getStoreConfig('payment/ipay88_hosted/ipay88_paypal_bank_config'),
        );
    }



    public function getWiget() {
        $bankConfigurations = $this->prepareHostedBankConfig();
        $imagePath = $this->getImageBankPath();
        $logoIpay88 = $imagePath . DIRECTORY_SEPARATOR . 'logo.gif';

        $bConfigs = array_filter($bankConfigurations);
        $ipay88Indonesia = new Ipay88_Indonesia();
        $paymentIds = array();

        if($bConfigs) {
            foreach ($bConfigs as $key => $value) {
                $info = $ipay88Indonesia->getPaymentMethodInfoByKey($key);
                $paymentIds[] = $info['paymentId'];
            }
        }

        $groupConfigs = $ipay88Indonesia->prepareBankConfiguration($paymentIds);

        $html =
            '<div class="payment_method_ipay88">
                <fieldset>
		  	        <legend>Please choose bank to pay:</legend>
                    <ul>';
                        if(is_array($groupConfigs) && count($groupConfigs)) {
                            foreach ($groupConfigs as $groupId => $data) {
                                $group = $ipay88Indonesia->getGroup($groupId);

                                if($data) {
                                $html .=
                                    '<ul>
                                        <div class="ido-group-name">'.$group.'</div>';
                                    if(is_array($data) && count($data)) {
                                        foreach ($data as $paymentId) {
                                            $bank = $ipay88Indonesia->getPaymentMethodInfoById($paymentId);

                                            if(is_array($bank) && count($bank)) {
                                                $name = isset($bank['name']) ? $bank['name'] : '';

                                                $logo = $imagePath . DIRECTORY_SEPARATOR . (isset($bank['logo']) ? $bank['logo'] : '');

                                                $html .=
                                                    '<li>
					                        <input type="radio" class="ipay88_indo_bank" name="ipay88_indo_bank" value="'.$paymentId.'" title="'.$name.'">
                                            <img src="'.$logo.'" alt="" class="ipay88_bank_logo" style="width:100px; height:33px">';
                                                $html .=
                                                    '</li>';
                                            }
                                        }
                                    }


                                $html .=
                                    '</ul>';
                                }
                            }
                        }
        $html .=
                    '</ul>
                </fieldset>
            </div>';

        return $html;
    }

    public function getImageBankPath() {
        $skinPath = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN);
        return $skinPath . 'frontend/base/default/images/ipay88/banks';
    }
}
