<?php

/**
 * Ipay88 Inc
 * @author Ipay88 Inc <pvchi@ipay88.com>
 * @package Ipay88\ThirdpartyIntegration\Magento
 * @Description: Using for Indonesia Only
 */

class Ipay88_Ipay88_Model_Method_Hosted extends Ipay88_Ipay88_Model_Method_Abstract {

    protected $_isInitializeNeeded = false;
    protected $_canUseInternal = false;
    protected $_canUseForMultishipping = false;
    protected $_canCapture = false;
    protected $_canAuthorize = false;
    protected $_canVoid = false;
    protected $_canReviewPayment = false;
    protected $_canCreateBillingAgreement = false;

    /**
     * Constructor method.
     * Set some internal properties
     */
    public function __construct() {
        parent::__construct('hosted');
    }

    /**
     * The method is used to save payment related fields along with other order information.
     * @param $data
     * @return mixed
     */
    public function assignData($data) {

        if (!($data instanceof Varien_Object)) {
            $data = new Varien_Object($data);
        }

        $info = $this->getInfoInstance();
        $info->setIpay88HostedPaymentMethodId($data->getIpay88HostedPaymentMethodId());

        $info->setAdditionalInformation('ipay88_hosted_payment_method_id', $data->getIpay88HostedPaymentMethodId());

        return $this;
    }

    /**
     *
     * @return $this
     * @throws Mage_Core_Exception
     */
    public function validate()
    {
        parent::validate();

        $info = $this->getInfoInstance();

        $paymentId = $info->getIpay88HostedPaymentMethodId();

        $errors = array();

        if(empty($paymentId)) {
            $errors[] = $this->_getHelper()->__('You must select a bank to pay!');
        }

        if(empty($errors)){
            $errorCode = 'invalid_data';
            $errorMsg = implode('<br/>', $errors);
        }

        if(isset($errorMsg) && $errorMsg){
            Mage::throwException($errorMsg);
        }

        return $this;
    }

    public function getOrderPlaceRedirectUrl()
    {
        return Mage::getUrl('ipay88/hosted/redirect', array('_secure' => false));
    }

    public function getStatusIdAfterPayment() {
        return Mage::getStoreConfig('payment/ipay88_hosted/order_status_after_payment');
    }
}