<?php
/**
 * Ipay88 Inc
 * @author Ipay88 Inc <pvchi@ipay88.com>
 * @package Ipay88\ThirdpartyIntegration\Magento
 * @Description: Using for Indonesia Only
 */
require_once Mage::getBaseDir('lib') . '/ipay88-php/Include.php';

class Ipay88_Ipay88_HostedController extends Mage_Core_Controller_Front_Action
{
    const ORDER_STATUS_AFTER_REQUERY_SUCCESS = 'processing';

    public function redirectAction()
    {
        $this->loadLayout();
        $block = $this->getLayout()->createBlock('Mage_Core_Block_Template','ipay88',array('template' => 'ipay88/checkout/hosted/redirect.phtml'));
        $this->getLayout()->getBlock('content')->append($block);

        $this->renderLayout();
    }

    public function callbackAction() {
        $paymentStatus = $this->getRequest()->get("Status");
        $paymentId = $this->getRequest()->get("PaymentId");
        $refNo = $this->getRequest()->get("RefNo");
        $amount = $this->getRequest()->get("Amount");
        $currency = $this->getRequest()->get("Currency");
        $remark = $this->getRequest()->get("Remark");
        $transId = $this->getRequest()->get("TransId");
        $authCode = $this->getRequest()->get("AuthCode");
        $errorDesc = $this->getRequest()->get("ErrDesc");
        $signature = $this->getRequest()->get("Signature");

        $commentData = array(
            'Pay Via: iPay88 Hosted Payment Gateway',
            'PaymentId: '.$paymentId,
            'RefNo: '.$refNo,
            'Amount: '.$amount,
            'Currency: '.$currency,
            'Remark: '.$remark,
            'TransId: '.$transId,
            'AuthCode: '.$authCode,
            'ErrDesc: '.$errorDesc,
            'Signature: '.$signature,
        );

        $orderId = $this->getRequest()->get("RefNo");
        $order = Mage::getModel('sales/order')->loadByIncrementId($orderId);

        // Check signature
        $hostedModel = Mage::getSingleton('ipay88/method_hosted');

        $merchantCode = $hostedModel->getConfigData('ipay88_merchant_code');
        $merchantKey  = $hostedModel->getConfigData('ipay88_merchant_key');
        $amount = $order->getGrandTotal();
        $myamount = number_format($amount, 2, '.', ',');
        $orderAmount = str_replace(".", "", str_replace(",", "", $myamount));

        // Signature
        $source =  $merchantKey . $merchantCode . $paymentId . $refNo . $orderAmount . $currency . $paymentStatus;
        $iPay88_Signature = new Ipay88_Signature($source);
        $mySignature = $iPay88_Signature->getSignature();
        //end check

        if($paymentStatus == Ipay88_Config::PAYMENT_STATUS_SUCCESS && $mySignature == $signature) {
            $commentData[] = 'Status: 1 (Successful)';
            $commentData = implode('<br/>', $commentData);
            $paymentStatusSuccess = $hostedModel->getStatusIdAfterPayment();
            $order->setState($paymentStatusSuccess, true, "Payment Successed");
            $order->addStatusHistoryComment($commentData);
            $order->save();

            $order->sendNewOrderEmail();

            Mage::getSingleton('checkout/session')->unsQuoteId();
            Mage_Core_Controller_Varien_Action::_redirect('checkout/onepage/success', array('_secure'=> false));

        } elseif ($paymentStatus == Ipay88_Config::PAYMENT_STATUS_PENDING && $mySignature == $signature) {
            $commentData[] = 'Status: 6 (PENDING)';
            $commentData = implode('<br/>', $commentData);
            $order->setState(Mage_Sales_Model_Order::STATE_PENDING_PAYMENT, true, "Payment Pending");
            $order->addStatusHistoryComment($commentData);
            $order->save();

            Mage::getSingleton('checkout/session')->unsQuoteId();
            Mage_Core_Controller_Varien_Action::_redirect('ipay88/hosted/pending', array('_secure'=> false));

        } else {
            $commentData[] = 'Status: 0 (Failed)';
            $commentData = implode('<br/>', $commentData);
            $errorDescription = 'Payment Fail. ' .$this->getRequest()->get("ErrDesc");
            $order->setState(Mage_Sales_Model_Order::STATE_CANCELED, true, $errorDescription);
            $order->addStatusHistoryComment($commentData);
            $order->cancel();
            $order->save();

            $order->sendNewOrderEmail();

            foreach ($order->getAllItems() as $item) {
                $item->cancel();
            }

            Mage_Core_Controller_Varien_Action::_redirect('ipay88/hosted/error', array('_secure'=> false));
        }
    }

    private function createInvoiceIpay88($order) {
        try {
            if(!$order->canInvoice())
            {
                Mage::throwException(Mage::helper('core')->__('Cannot create an invoice.'));
            }

            $invoice = Mage::getModel('sales/service_order', $order)->prepareInvoice();

            if (!$invoice->getTotalQty()) {
                Mage::throwException(Mage::helper('core')->__('Cannot create an invoice without products.'));
            }

            $invoice->setRequestedCaptureCase(Mage_Sales_Model_Order_Invoice::CAPTURE_ONLINE);
            $invoice->register();
            $transactionSave = Mage::getModel('core/resource_transaction')
                ->addObject($invoice)
                ->addObject($invoice->getOrder());

            $transactionSave->save();
        }
        catch (Mage_Core_Exception $e) {

        }
    }

    /**
     * Action that handles response from ipay88 when payment success
     * @return string
     */
    public function ipnAction()
    {
        $orderId = $this->getRequest()->get("RefNo");

        $hostedModel = Mage::getSingleton('ipay88/method_hosted');
        $status = $hostedModel->getStatusIdAfterPayment();

        if($orderId) {
            $order = Mage::getModel('sales/order')->loadByIncrementId($orderId);
            $order->setState($status, true);

            $paymentStatus = $this->getRequest()->get("Status");
            $paymentId = $this->getRequest()->get("PaymentId");
            $refNo = $this->getRequest()->get("RefNo");
            $amount = $this->getRequest()->get("Amount");
            $currency = $this->getRequest()->get("Currency");
            $remark = $this->getRequest()->get("Remark");
            $transId = $this->getRequest()->get("TransId");
            $authCode = $this->getRequest()->get("AuthCode");
            $errorDesc = $this->getRequest()->get("ErrDesc");
            $signature = $this->getRequest()->get("Signature");

            $commentData = array(
                'Pay Via: iPay88 Hosted Payment Gateway',
                'PaymentId: '.$paymentId,
                'RefNo: '.$refNo,
                'Amount: '.$amount,
                'Currency: '.$currency,
                'Remark: '.$remark,
                'TransId: '.$transId,
                'AuthCode: '.$authCode,
                'ErrDesc: '.$errorDesc,
                'Signature: '.$signature,
            );

            // Check signature
            $hostedModel = Mage::getSingleton('ipay88/method_hosted');

            $merchantCode = $hostedModel->getConfigData('ipay88_merchant_code');
            $merchantKey  = $hostedModel->getConfigData('ipay88_merchant_key');
            $amount = $order->getGrandTotal();
            $myamount = number_format($amount, 2, '.', ',');
            $orderAmount = str_replace(".", "", str_replace(",", "", $myamount));
            $currency =  $order->order_currency_code;

            // Signature
            $source =  $merchantKey . $merchantCode . $paymentId . $refNo . $orderAmount . $currency . $paymentStatus;
            $iPay88_Signature = new Ipay88_Signature($source);
            $mySignature = $iPay88_Signature->getSignature();

            // If status == 1 and signature matched => update order status and return string: RECEIVEOK
            if($paymentStatus == Ipay88_Config::PAYMENT_STATUS_SUCCESS && $mySignature == $signature) {
                $commentData[] = 'Status: 1 (Successful)';
                $order->setState($status, true);
                $commentData = implode('<br/>', $commentData);
                $order->addStatusHistoryComment($commentData);
                
                $order->save();
                $order->sendNewOrderEmail();
                $this->createInvoiceIpay88($order);

                $this->loadLayout();
                $this->getResponse()->setBody(
                    $this->getLayout()->createBlock('Mage_Core_Block_Template','ipay88',array('template' => 'ipay88/checkout/ipn.phtml'))->toHtml()
                );
                Mage::log('Payment successfully', null, 'ipay88.log');
            } else {
                $order->cancel();
                $order->save();
                Mage::log('Payment failed', null, 'ipay88.log');
                die('Payment failed Log');
            }
        } else {
            echo "Invalid Parameters";
            Mage::log('Invalid Parameters', null, 'ipay88.log');
        }
    }

    /**
     * Action that handles requery call from Ipay88 system
     * @return string
     */
    public function errorAction()
    {
        $this->loadLayout();
        $block = $this->getLayout()->createBlock('Mage_Core_Block_Template','ipay88',array('template' => 'ipay88/checkout/error.phtml'));
        $this->getLayout()->getBlock('content')->append($block);
        $this->renderLayout();
    }

    /**
     * Action that handles requery call from Ipay88 system
     * @return string
     */
    public function pendingAction()
    {
        $this->loadLayout();
        $block = $this->getLayout()->createBlock('Mage_Core_Block_Template','ipay88',array('template' => 'ipay88/checkout/pending.phtml'));
        $this->getLayout()->getBlock('content')->append($block);
        $this->renderLayout();
    }
}